Attribute VB_Name = "modGroups"
'-----------------------------------------------------
' MirageBot Groups Module
' Written by Christopher Nevin (lancergli@gmail.com)
'-----------------------------------------------------

Option Explicit

Public Groups() As clsGroup
Public GroupsLoaded As Boolean

Public Function IsGroup(Group As String) As Boolean
    Dim I As Integer, C As Integer
    C = UBound(Groups)
    For I = 0 To C
        If LCase$(Group) = LCase$(Groups(I).Name) Then
            IsGroup = True
            Exit Function
        End If
    Next
End Function

Public Sub RefreshChannel()
On Error GoTo hErr
    If SelectedBot = -1 Then Exit Sub
    Dim O As Integer, C As Boolean
1   For O = 1 To frmBot.lvUsers(SelectedBot).ListItems.Count
2       With frmBot.lvUsers(SelectedBot).ListItems.Item(O)
3           Dim U As UserInfo, S As clsUser
4           Set S = frmBot.Bot(SelectedBot).Users.GetByName(.Tag)
5           If Not S Is Nothing Then
6               U = GetInformation(SelectedBot, .Tag, S.Statstring, S.Flags, S.Ping)
7               If .ForeColor <> U.color Then C = True: .ForeColor = U.color
8               If .SmallIcon <> U.Icon Then C = True: .SmallIcon = U.Icon
9               If .ListSubItems(1).Text <> U.Clan Then C = True: .ListSubItems(1).Text = U.Clan
                If U.Clan = frmBot.Bot(SelectedBot).Clan.Tag Then
                    .ListSubItems(1).ForeColor = modStyles.ClanColor.cl_yourclan
                Else
                    .ListSubItems(1).ForeColor = modStyles.ClanColor.cl_clan
                End If
11              If .ListSubItems(2).Text <> U.Ping Then C = True: .ListSubItems(2).Text = U.Ping
12              If .ListSubItems(2).ForeColor <> U.PingColor Then C = True: .ListSubItems(2).ForeColor = U.PingColor
13              Set S = Nothing
            End If
        End With
    Next
14  If C Then frmBot.lvUsers(SelectedBot).Refresh
    Exit Sub
hErr:
    Close #1
    ErrorHandler Err.Description, Erl, "Groups", "RefreshChannel"
End Sub

Public Function AddToGroup(ByVal Group As String, Username As String) As Boolean
On Error GoTo hErr
    If GroupsLoaded = True Then
        Dim I As Integer, Count As Long
        Group = LCase$(Group)
        Count = UBound(Groups)
        For I = 0 To Count
            If LCase$(Groups(I).Name) = Group Then
                Groups(I).Add Username
                Groups(I).SaveGroup
                AddToGroup = True
                Exit Function
            End If
        Next I
    End If
    Exit Function
hErr:
    ErrorHandler Err.Description, Erl, "Groups", "AddToGroup"
End Function

Public Function RemoveFromGroup(Username As String) As Boolean
On Error GoTo hErr
    If GroupsLoaded = True Then
        Dim I As Integer, Count As Long
        Count = UBound(Groups)
        For I = 0 To Count
            If Groups(I).IsInGroup(Username) Then
                RemoveFromGroup = Groups(I).Remove(Username)
                Groups(I).SaveGroup
                Exit Function
            End If
        Next I
    End If
    Exit Function
hErr:
    ErrorHandler Err.Description, Erl, "Groups", "RemoveFromGroup"
End Function

Public Function GetGroupColor(Username As String) As Long
On Error GoTo hErr
    Dim I As Integer, Count As Long
    Count = UBound(Groups)
    For I = 0 To Count
        If Not Groups(I) Is Nothing Then
            If Groups(I).IsInGroup(Username) Then
                GetGroupColor = Groups(I).color
                Exit Function
            End If
        End If
    Next I
hErr:
    GetGroupColor = -1
End Function

Public Function GetGroupName(Username As String) As String
On Error GoTo hErr
    If GroupsLoaded = True Then
        Dim I As Integer, Count As Long
        Count = UBound(Groups)
        For I = 0 To Count
            If Groups(I).IsInGroup(Username) Then
                GetGroupName = Groups(I).Name
                Exit Function
            End If
        Next I
    End If
    Exit Function
hErr:
    ErrorHandler Err.Description, Erl, "Groups", "GetGroupName"
End Function

Public Sub RefreshGroups()
On Error GoTo hErr
    Dim I As Integer
    For I = frmBotMenu.mnuGroups.UBound To 1 Step -1
        Unload frmBotMenu.mnuGroups(I)
    Next I
    frmBotMenu.mnuGroups(0).Checked = False
    frmBotMenu.mnuGroups(0).Caption = "-"
    If GroupsLoaded = True Then
        If ArrayInit(Not Groups) Then
            If LenB(Groups(0).Name) <> 0 Then
                Dim Count As Long
                Count = UBound(Groups)
                For I = 0 To Count
                    If frmBotMenu.mnuGroups(0).Caption = "-" Then
                        frmBotMenu.mnuGroups(0).Caption = Groups(I).Name
                    Else
                        Load frmBotMenu.mnuGroups(frmBotMenu.mnuGroups.Count)
                        frmBotMenu.mnuGroups(frmBotMenu.mnuGroups.UBound).Caption = Groups(I).Name
                    End If
                Next I
            End If
        End If
    End If
'    If frmBotmenu.mnuGroups(0).Caption = "-" Then
'        frmBot.mnclsGroup.Visible = False
'
'    End If
    Exit Sub
hErr:
    Close #1
    ErrorHandler Err.Description, Erl, "Group", "RefreshGroups"
End Sub

Public Sub LoadGroups()
    ReDim Groups(0)
    GroupsLoaded = False
On Error GoTo hErr
    Dim Files() As String, I As Integer, N As Integer, TS As TextStream
    CreateFolder AppData & "Data\Preferences\Groups\"
    If LenB(Dir$(AppData & "Data\Preferences\Groups\")) <> 0 Then
        Files = FileList(AppData & "Data\Preferences\Groups\*.txt")
        If ArrayInit(Not Files) Then
            ReDim Groups(UBound(Files()))
            GroupsLoaded = True
            For I = 0 To UBound(Files())
                Set Groups(I) = New clsGroup
                Groups(I).Clear
                Groups(I).Name = Left$(Files(I), InStrRev(Files(I), ".") - 1)
                Dim FSO As New FileSystemObject
                Set TS = FSO.OpenTextFile(AppData & "Data\Preferences\Groups\" & Files(I), ForReading, True)
                Set FSO = Nothing
                Dim Content As String, lines() As String
                If TS.AtEndOfStream = False Then
                    Content = TS.ReadAll()
                    TS.Close
                    If InStrB(Content, vbNewLine) <> 0 Then
                        lines = Split(Content, vbNewLine)
                        If lines(0) Like "Color=*" Then
                            Groups(I).color = Val(Mid$(lines(0), 7))
                        End If
                        If Groups(I).color = 0 Then Groups(I).color = vbWhite
                        For N = 1 To UBound(lines)
                            If LenB(lines(N)) <> 0 Then
                                Groups(I).Add lines(N)
                            End If
                        Next N
                    End If
                End If
            Next I
        End If
    End If
    Exit Sub
hErr:
    Close #1
    ErrorHandler Err.Description, Erl, "Group", "LoadGroups"
End Sub

